## The Sleeper Cell

The challenge involves decoding an intercepted email from the Androktasiai terrorist group that contains encoded target coordinates. The goal is to decrypt the message and find the hidden target location information.

## Available Materials

1. Base64 encoded text  
2. Email title: “Rise of Androktasiai”  
3. Context about the terrorist organization  
4. Information about a sleeper cell activation

## Solution Path

### Step 1: Initial Decoding

Start with the Base64 encoded text: (sample)

```

SSB1cmdzIG9rZSBscGlhIHR2cHYgbXluIGhzZGUgaWxlaHJyaSB5b212ZCB3dWcgZXAgaHJ4IHdnemRhIGF5dXZvbnIgc2h3a21u...
```

### Step 2: Base64 to Decimal Conversion

1. Decode the Base64 text  
2. Convert to decimal representation  
3. Prepare for Vigenere decryption

### Step 3: Vigenere Decryption

Key elements:

1. Use “Androktasiai” as the key  
2. Apply Vigenere decryption algorithm  
3. Process the full text

### Step 4: Target Extraction

Look for the coordinates format:

```

SoFi-Stadium-33.953417,-118.338863,18
```

Elements to note:

1. Location name (SoFi Stadium)  
2. Latitude (33.953417)  
3. Longitude (-118.338863)  
4. Zoom/height level (18)

## Required Tools

1. Base64 decoder  
2. Decimal converter  
3. Vigenere cipher decoder  
4. Text editor

## Common Pitfalls to Avoid

1. Wrong decoding order  
2. Incorrect Vigenere key spelling  
3. Missing coordinate components  
4. Overlooking hidden markers (double parentheses)  
5. Case sensitivity in final answer

## Decoding Process

1. Base64 Decoding:  
* Use standard Base64 decoder  
* Verify complete text conversion  
1. Decimal Conversion:  
* Convert decoded text to decimal  
* Maintain proper formatting  
1. Vigenere Decryption:  
* Use key: “Androktasiai”  
* Process entire text  
* Look for readable output

## Verification Steps

1. Confirm Base64 decoding  
2. Verify decimal conversion  
3. Check Vigenere decryption  
4. Locate coordinate markers  
5. Validate target location

Remember: The key to this challenge is methodical decryption and careful attention to the hidden location format within the decoded text.

