## The Raid CTF

This challenge presents a recovered file from a wiped hard disk during an FBI raid. The file contains intentionally misleading content, and the true solution lies in the filename itself rather than the file contents.

## Available Materials

1. Recovered file with various content  
2. Context of FBI raid on cybercrime operation  
3. Information about file recovery

## Solution Path

### Step 1: Initial File Analysis

Important realizations:

1. The file contains an encoded image of Rick Astley (a misdirection)  
2. The hex data is meant to distract  
3. The key is in the filename itself: “psvoxkwo8mm”

### Step 2: Filename Decoding

1. The filename is encoded using ROT47 with \-10 steps  
2. Decoding process:  
* Take “psvoxkwo8mm”  
* Apply ROT47 (-10 steps)  
* Results in “filename.cc”

### Step 3: URL Resolution

1. Visit filename.cc  
2. This forwards to a file:

```

https://filelu.cloud/A2lpAIclajewfCYC/answer-the-raid.txt
```

### Step 4: Password Extraction

The final password is:

```

flag-gh32398D#C*$C#)\*$V3405hv3j524952
```

## Key Points

1. Don’t get distracted by file contents  
2. Focus on the filename  
3. Use ROT47 decoding  
4. Follow Google Drive link  
5. Extract exact password

## Common Pitfalls to Avoid

1. Analyzing hex data unnecessarily  
2. Getting distracted by Rick Astley image  
3. Wrong ROT47 direction  
4. Missing URL forwarding  
5. Incorrect password copying

## Analysis Tools Needed

1. ROT47 decoder  
2. Web browser  
3. Text editor  
4. Hex viewer (but don’t waste time with it)

## Tips for Solvers

1. Don’t dive too deep into file contents  
2. Remember everything could be misdirection  
3. Focus on simple solutions first  
4. Pay attention to the filename  
5. Follow URL forwarding carefully

## Verification Steps

1. Confirm ROT47 decoding  
2. Verify URL forwards to Google Drive  
3. Access Google Drive folder  
4. Validate password format  
5. Test final solution

## Important Notes

1. File content is intentionally misleading  
2. Solution is simpler than it appears  
3. Multiple layers of misdirection  
4. Focus on the obvious (filename)  
5. Don’t overcomplicate the analysis

Remember: This challenge is designed to teach that sometimes the most obvious solution (the filename) is correct, and complex analysis (file contents) can be a distraction.

