## On the Wire

This challenge involves analyzing a packet capture file obtained from a Malaysian politician’s office, who is involved with a Chinese criminal enterprise trafficking in endangered animals. The goal is to discover hidden communications within the network traffic.

## Available Materials

1. Packet capture file (with modified extension)  
2. Context about illegal wildlife trafficking operation  
3. Information about anonymous messaging system

## Solution Path

### Step 1: Initial File Analysis

1. Identify the packet capture file despite modified extension  
2. Open the file using appropriate tools:  
* Wireshark  
* tcpdump  
* Network Miner  
* Other pcap analysis tools

### Step 2: Traffic Analysis

Key areas to examine:

1. DNS queries  
2. Specifically look for NSLOOKUP commands  
3. Focus on external communications  
4. Look for unusual domains or IPs  
5. Track DNS resolution requests

### Step 3: Discovering the Pastebin

The packet capture contains an NSLOOKUP to:

```

https://pastebin.com/raw/U7zb8Kyh
```

### Step 4: Final URL

The Pastebin content leads to the bit.ly URL that serves as the password:

```

https://bit.ly/3qyrf7t
```

## Required Tools

1. Packet Analysis Software:  
* Wireshark (recommended)  
* tcpdump  
* NetworkMiner  
1. Text editor for examining extracted content  
2. Web browser for accessing discovered URLs

## Common Pitfalls to Avoid

1. Missing the modified file extension  
2. Overlooking DNS queries  
3. Not following the complete chain of URLs  
4. Missing the raw pastebin URL format  
5. Incorrect URL copying

## Analysis Methodology

1. File Examination:  
* Verify file type regardless of extension  
* Open with appropriate analysis tool  
1. Traffic Analysis:  
* Filter for DNS traffic  
* Look for NSLOOKUP commands  
* Examine external communications  
1. URL Chain:  
* Follow Pastebin URL  
* Extract bit.ly link  
* Verify complete URL format

## Verification Steps

Confirm:

1. Correct file opening  
2. Complete DNS query identification  
3. Proper Pastebin URL extraction  
4. Accurate bit.ly link copying  
5. Proper URL formatting

## Additional Tips

1. Pay attention to DNS traffic  
2. Look for patterns in communications  
3. Follow the complete chain of references  
4. Verify all URLs carefully  
5. Document findings systematically

Remember: The key to this challenge is methodical analysis of network traffic and careful attention to the chain of references from DNS lookup to final URL.

