## Lost at Sea

A surveillance ship disguised as a fishing trawler has sunk in the Black Sea. Players need to crack the password for an encrypted log file from the ship’s emergency beacon to discover its final location and circumstances.

## Available Materials

1. Emergency beacon log file  
2. Ship details and background information  
3. Context about the ship’s mission  
4. Time of last contact (22:34 EET)

## Solution Path

### Step 1: Password Analysis

Key information from the briefing to determine the password:

1. Ship name: “Narwhal”  
2. Built in 2018  
3. Looks like a fishing trawler  
4. Houses 10 crew members  
5. Contains advanced surveillance equipment

The password combines two key pieces of information:

```

Narwhal2018
```

Password construction logic:

* Ship name: “Narwhal”  
* Build year: “2018”  
* No spaces  
* Proper capitalization (first letter only)

### Step 2: Log File Analysis

Once decrypted, the log reveals:

1. Final coordinates: 44.470394, 32.264429  
2. Heading: NNE 32  
3. Speed: 7 knots (12.964 KMPH)  
4. Series of events leading to impact

### Step 3: Event Sequence Analysis

Key events from the log:

1. Initial detection: SE 132 3.00S  
2. Multiple incoming warnings  
3. Impact warnings  
4. Data dump writing  
5. Probe beacon ejection (KMZ784S)

## Common Pitfalls to Avoid

1. Wrong password capitalization  
2. Trying complex password combinations  
3. Missing the significance of the build year  
4. Incorrect coordinate formatting  
5. Looking for the deprecated bit.ly link

## Tools Needed

1. Text editor  
2. Archive extraction software  
3. Coordinate mapping tool  
4. Basic cryptographic knowledge

## Tips for Solvers

1. Focus on ship details in briefing  
2. Pay attention to construction year  
3. Note proper name capitalization  
4. Consider simple password construction  
5. Analyze event sequence carefully

## Verification Steps

1. Confirm password format  
2. Verify coordinate accuracy  
3. Check heading and speed data  
4. Review event sequence  
5. Validate location in Black Sea

## Key Information

1. Ship was built in 2018  
2. Operating in Black Sea  
3. Disguised as fishing trawler  
4. Last contact at 22:34 EET  
5. Advanced surveillance capabilities

Remember: The key to this challenge is recognizing that the password would be something simple enough for daily changes while still being secure enough for classified operations.

