## Kidnapped

A US diplomat’s daughter has been kidnapped, and we need to decode an encrypted message to find her location. The message uses multiple layers of encryption, and the answer will be in what3words format.

## Available Materials

1. Encrypted message (Base64 encoded)  
2. Time constraint (18 hours remaining from 24\)  
3. Context about the kidnapper’s motives (Iraq war connection)

## Solution Path

### Step 1: Initial Decoding

Start with Base64 decoding of the original message:

```

Y2MgZWQgZWAgZmEgYV8gY0IgZmEgYUMgYV8...
```

### Step 2: ROT47 Decryption

After Base64 decoding, the text needs to be decrypted using ROT47, resulting in hex values:

```

44 65 61 72 20 4q 72 2r 20 41 6r...
```

### Step 3: Hex Decoding with Character Substitution

Key character substitutions needed:

1. q → d  
2. r → e  
3. s → f  
4. o → b  
5. p → c

The decoded text contains encoded locations in what3words format:

```

inched.barman.fast
```

## Key Components

1. Base64 decoding  
2. ROT47 decryption  
3. Hex decoding  
4. Character substitution table  
5. what3words format recognition

## Common Pitfalls to Avoid

1. Missing character substitutions  
2. Incomplete decoding steps  
3. Wrong order of operations  
4. Overlooking the what3words format  
5. Incorrect character mapping

## Required Tools

1. Base64 decoder  
2. ROT47 decoder  
3. Hex decoder  
4. Text editor for substitutions  
5. what3words validator

## Verification Steps

1. Check Base64 decoding  
2. Verify ROT47 output  
3. Confirm hex values  
4. Apply all character substitutions  
5. Validate what3words format

## Tips for Solvers

1. Follow decoding steps in order  
2. Pay attention to patterns in substituted characters  
3. Use systematic substitution approach  
4. Check for consistent patterns  
5. Verify what3words format compliance

Remember: The key to this challenge is recognizing the multiple layers of encoding and systematically applying the correct substitutions to reveal the what3words location.

