## Gas Attack

The challenge involves identifying a city from a satellite image that has been shared on the dark web by a terrorist group planning a chemical attack. The image needs to be analyzed to determine the exact location.

## Available Materials

1. Satellite image of a city  
2. Context about it being a potential target  
3. Information about formatting requirements

## Solution Paths

### Path 1: Reverse Image Search (Quick Solution)

1. Save the provided satellite image  
2. Use various RIS tools:  
* Google Images  
* Yandex Images  
* Bing Visual Search  
* TinEye  
1. Results should quickly identify the city

### Path 2: Manual Geolocation (Alternative Method)

If RIS fails, look for:

1. Distinctive architectural features  
2. Road layout patterns  
3. Major landmarks  
4. Urban planning style  
5. Water features or green spaces

## Answer Format

Must follow this exact format:

```

country-city
```

Example format:

```

belgium-brussels
```

Key formatting rules:

1. All lowercase  
2. Single hyphen between country and city  
3. No spaces  
4. Use English spelling of locations  
5. Remove special characters

## Common Pitfalls to Avoid

1. Wrong case usage  
2. Incorrect spelling of city/country  
3. Missing hyphen  
4. Extra spaces  
5. Using local language names  
6. Wrong format order

## Verification Steps

1. Confirm location matches image  
2. Check country spelling  
3. Verify city spelling  
4. Ensure proper formatting  
5. Compare with example format

## Research Tools

1. Google Images  
2. Yandex Images  
3. TinEye  
4. Bing Visual Search  
5. Google Earth (for verification)

Remember: While RIS is the quickest solution path, it’s good practice to verify the location using other methods to ensure accuracy.

