## Emergency Transmission

A Klumgon pilot has been shot down over Ecuador, and we need to decode an emergency transmission to find their exact coordinates. The challenge involves a multi-step decryption process of intercepted communications.

## Available Materials

1. Radio transmission transcript between the pilot and Air Traffic Control  
2. Encrypted message from a local cell tower  
3. The vessel’s registration number “KLUMKLOOV” (important for decryption)  
4. Base85 encoded message  
5. Final coordinate format requirements

## Solution Path

### Step 1: Initial Decoding – Base85

The first step is to decode the Base85 encoded message. Base85 (also known as Ascii85) is a form of binary-to-text encoding that’s more efficient than Base64.

Take the provided encoded string:

```

9g_9;;bg+l+@/Y"7RodA$;j/_6;KsP91;c%7TrYg9h%HC868Dc$:mij6rZKQ+B_?+<?Ob6+AZ'/7LDLZ85N5f<?Ob3:/je-7RBd87n?QH9iY>!$?C'&EZf[AE?K.FBHUu/Gp%*:BQ##>@WNZ+F*W%A+E2X@Aftu4BcqV.GBe$KEctr6+Dl+1E+0r2A8u[.+E2U;+D>q8Df?h9EFs0!+DuL7H6?pJD]iS7C`mV6B6eeGD0fW!Fs)'UGp%ESH#mR)7p/5T+AZ-C6;puS<(U7#6;U3B<)Zpc$:IZY7SQ9Q;@6)p6pj[M8Po
```

This needs to be decoded using Base85 decoding.

### Step 2: Vigenere Cipher Decryption

After the Base85 decoding, the resulting text needs to be decrypted using a Vigenere cipher:

* Key: “KLUMKLOOV” (from the pilot’s vessel registration number in the briefing)  
* The Vigenere cipher is a polyalphabetic substitution cipher that uses a keyword to encrypt/decrypt text

### Step 3: Coordinate Extraction

After decryption, you’ll get the coordinates in this format:

```

dash one dot two five one niner four six comma dash seven eight dot three seven zero one six seven comma one niner
```

### Step 4: Format Conversion

Convert the military-style spoken coordinates to numerical format:

* “dash” → “-“  
* “niner” → “9”  
* “dot” → “.”  
* “comma” → “,”

Final format: `-1.251946,-78.370167,19`

## Required Answer Format

The coordinates must be submitted in this exact format:

```

-0.000000,-00.000000,00
```

Key formatting rules:

* Include negative signs where needed  
* Use exact number of decimal places  
* Include commas between components  
* No spaces  
* Include altitude number

## Tips for Solvers

1. Use reliable Base85 decoding tools  
2. Double-check the Vigenere key spelling (“KLUMKLOOV”)  
3. Pay attention to the military number format conversion  
4. Verify coordinates fall within Ecuador  
5. Follow the exact format requirements

## Common Pitfalls to Avoid

1. Using wrong Vigenere key (watch for spelling)  
2. Incorrect Base85 decoding tool  
3. Missing any decryption steps  
4. Wrong coordinate format  
5. Incorrect conversion of military numbers

## Tools Needed

1. Base85 decoder  
2. Vigenere cipher decoder  
3. Text-to-coordinate converter

## Verification Steps

Verify altitude component is included

Confirm Base85 decode was successful

Verify Vigenere decryption produced readable text

Check coordinates fall within Ecuador

Ensure exact formatting matches requirements

