## Where’s Klumgongyn

Our alien friend Klumgongyn has taken an impromptu vacation in protest of excessive GIF usage, leaving only a photo as a clue to his location. The goal is to identify the exact street location in the Maldives where the photo was taken.

## Available Materials

1. Vacation photo from Klumgongyn  
2. Context that it’s a tourist location  
3. Information about format requirements

## Solution Path

### Step 1: Image Analysis

Look for:

1. Architectural style  
2. Environmental clues  
3. Tourist infrastructure  
4. Tropical setting  
5. Ocean proximity

### Step 2: Location Identification

Key location data:

* Country: Maldives  
* Street: Elhe Didi Magu  
* Google Street View available

### Step 3: Answer Format

Must follow this exact format:

```

country-street-name
```

Correct format:

```

maldives-elhe-didi-magu
```

## Format Requirements

1. All lowercase  
2. Hyphens between words  
3. No spaces  
4. Full street name  
5. Correct spelling  
6. English naming convention

## Common Pitfalls to Avoid

1. Wrong case usage  
2. Missing hyphens  
3. Incorrect street spelling  
4. Extra spaces  
5. Wrong word order  
6. Local language variations

## Research Tools

1. Google Street View  
2. Google Maps  
3. Street maps of Maldives  
4. Tourism websites  
5. Local area guides

## Verification Steps

1. Confirm country is Maldives  
2. Verify exact street name spelling  
3. Check formatting  
4. Validate hyphenation  
5. Confirm case sensitivity

## Additional Tips

1. Use Street View to confirm exact location  
2. Cross-reference tourist photos  
3. Check multiple angles  
4. Verify through local sources  
5. Confirm English spelling conventions

Remember: The key to this challenge is precise street identification and proper formatting of the location name.

