## The Spy Who Vanished

The challenge involves tracking down a deleted social media profile belonging to Deloris Frozenwood, a former MI5 operative who went rogue. The goal is to find archived information about her Twitter account using web archiving services.

## Available Materials

1. Target name: Deloris Frozenwood (also appears as “D Frozenwood”)  
2. Twitter handle: @DFrozenwood  
3. Background information about her MI5 career  
4. Context about her current activities as a rogue agent

## Solution Path

### Step 1: Initial Investigation

Gather known information:

1. Full name: Deloris Frozenwood  
2. Twitter handle: @DFrozenwood  
3. Original Twitter URL: https://twitter.com/DFrozenwood  
4. Context that the account has been deleted

### Step 2: Using the Wayback Machine

1. Visit web.archive.org  
2. Input the Twitter URL: https://twitter.com/DFrozenwood  
3. Look for archived snapshots  
4. Focus on the August 31, 2022 snapshot  
5. Navigate to: https://web.archive.org/web/20220831154130/https://twitter.com/DFrozenwood

### Step 3: Password Retrieval

The correct password format will be:

```

gnf435ynFJEFN#&$*F*D(*FSJ$Fkdfshh5f
```

## Key Points to Remember

1. The original Twitter account is deleted  
2. Must use web.archive.org  
3. Look for specific snapshot from August 31, 2022  
4. Pay attention to exact password formatting

## Common Pitfalls to Avoid

1. Trying to access the live Twitter profile  
2. Using wrong archival services  
3. Looking at wrong snapshot dates  
4. Incorrect password copying  
5. Missing special characters in password

## OSINT Techniques

1. Use web archives for deleted content  
2. Check multiple snapshot dates if available  
3. Verify account details match the briefing  
4. Document exact URLs and timestamps  
5. Pay attention to profile changes over time

## Verification Steps

Confirm:

1. Correct Twitter handle (@DFrozenwood)  
2. Proper archive timestamp  
3. Profile matches described background  
4. Exact password characters  
5. Special character formatting

## Research Methodology

1. Start with direct Twitter URL  
2. Use Wayback Machine’s calendar view  
3. Look for August 2022 snapshots  
4. Verify profile contents  
5. Document exact password string

## Additional Tips

1. Pay careful attention to special characters in the password  
2. Note the difference between similar-looking characters  
3. Be precise with underscores and asterisks  
4. Verify each character individually  
5. Double-check the entire password string

Remember: The key to this challenge is understanding that deleted social media content can often be found through web archives, and knowing how to navigate the Wayback Machine effectively.

