## The Road to Rome

This CTF challenge revolves around locating an ancient artifact called the “Cor Aquilae” (The Eagle’s Heart) containing the blood of Decimus Claudius Lucidus, a founder of the Ambulatores Umbrarum (Shadow Walkers). The challenge provides two main paths to the solution, making it accessible to different solving approaches.

## Available Materials

* An aerial photograph (appears to be from the 1940s)  
* A Latin riddle with its English translation  
* Historical context about Decimus Claudius Lucidus (152-87 BC)  
* Information about his travels on Roman roads in Italy

## Solution Paths

### Path 1: Geolocation

The primary solving path involves analyzing the provided aerial photograph of Castello di Brescia. Key features to note:

* The distinctive fortress layout  
* The geographical positioning on elevated ground  
* The architectural style typical of Italian fortifications

For geolocation, investigators should:

1. Focus on major Italian cities along ancient Roman roads  
2. Look for elevated fortifications  
3. Compare modern satellite imagery with the provided historical photo  
4. Pay special attention to fortresses in northern Italy, as this was a crucial region for Roman trade routes

### Path 2: Riddle Analysis

The provided riddle contains several key clues pointing to Castello di Brescia:

```

High atop the earth's embrace,
A watchful eye holds steadfast grace.
Once a haven for those who'd defy,
Where ten fleeting suns lit freedom's cry.
```

* References the fortress’s elevated position  
* Alludes to its role as a defensive structure  
* “Ten fleeting suns” likely refers to the Ten Days of Brescia uprising

```

Beneath the stone, a shadowed trail,
Where secrets whispered, plans set sail.
A keeper of arms both sharp and grand,
Its steel echoes a soldier's stand.
```

* References the underground passages beneath the castle  
* Mentions its historical use as an armory

```

Its crest bore pride of a lion's might,
A silent roar, a guardian's sight.
```

* Direct reference to the Venetian Lion, a key symbol associated with the fortress  
* Brescia was under Venetian rule, and the lion was their symbol

## Historical Context

The challenge leverages several historical elements:

* Roman trade routes through Italy  
* The strategic importance of Brescia in Roman times  
* The fortress’s role in various historical events  
* The Ten Days of Brescia uprising  
* Venetian influence in the region

## Submitting the Answer

The answer must be submitted in the exact format as shown on Google Maps:

* Correct format: castello-di-brescia  
* All lowercase  
* Hyphens between words  
* No special characters or spaces

## Tips for Solvers

1. Start with the geolocation approach as it’s the most straightforward  
2. Cross-reference historical events mentioned in the riddle  
3. Pay attention to architectural features in the aerial photo  
4. Consider the historical time period (152-87 BC) when analyzing potential locations  
5. Focus on locations that would have been strategically important during Roman times

## Common Pitfalls to Avoid

Be careful with the answer format – it must exactly match the Google Maps listing

Don’t focus exclusively on Rome itself; the challenge mentions “roads to Rome”

Don’t overlook the importance of the fortress’s elevation

