## The Listeners CTF Write-up

This CTF challenge involves locating a future meeting place between two business rivals in order to plant a listening device. The objective is to analyze an intercepted image and determine the exact address of the meeting location, which will be used to generate a password for accessing the contract card.

## Available Materials

* An intercepted photograph of the meeting location  
* Context that the targets favor luxurious lifestyles along Western and Southern European coastlines  
* Information about the meeting taking place at noon in 3 days

## Background Story

The challenge is set against the backdrop of corporate espionage and revenge. A wealthy French businessman’s yacht was attacked off the Spanish coast, endangering his wife and daughter. After their rescue, he seeks to gather intelligence on his rivals through a planted listening device, ultimately planning to destroy their businesses.

## Solution Path: Geolocation

The primary solving method involves careful analysis of the provided photograph to identify its location in Monaco. Key elements to consider:

1. Geographical Context:  
* Focus on Western and Southern European coastlines  
* Look for areas known for luxury and wealth  
* Consider locations popular with French business elites  
1. Visual Analysis:  
* Architecture style  
* Street layout  
* Building characteristics  
* Any visible signage or distinctive features  
1. Specific Location:  
* The location is on Boulevard de Belgique in Monaco  
* Building number 32  
* Located in the 98000 postal code area

## Password Generation

The password must follow this specific format:

```

country-zipcode-streetname-number
```

The correct password format would be:

```

Monaco-98000-Boulevard-de-Belgique-32
```

Key formatting rules:

* Use dashes between each component  
* Include the country name  
* Include the full street name with proper capitalization  
* Include the building number  
* Include the postal code

## Tips for Solvers

1. Start with the broader geographical context of Western/Southern Europe  
2. Focus on high-end areas given the targets’ preference for luxury  
3. Use multiple mapping tools to cross-reference potential locations  
4. Pay careful attention to architectural styles and building patterns  
5. Double-check all components of the password format  
6. Verify street names and numbers using official sources

## Common Pitfalls to Avoid

1. Don’t forget any components of the password format  
2. Ensure proper capitalization in street names  
3. Verify the exact postal code  
4. Double-check for proper hyphenation  
5. Make sure to use the official street name spelling

## Additional Context

The challenge plays into the broader narrative of high-stakes business rivalry and revenge, set against the backdrop of luxury European locations. Monaco, as the solution, perfectly fits the profile given:

* Known for wealth and luxury  
* Popular with French business elite  
* Coastal location  
* Distinctive architecture and urban planning

## Success Criteria

You’ll know you’ve found the correct location when:

The location fits the context of the mission briefing

The building matches the intercepted photograph exactly

The address components all align with official records

The generated password successfully unlocks the ZIP file

