## The Killer Clown

A serial killer dressed as a clown is burying victims alive in the San Francisco area, leaving only location photos as clues. We must identify the exact location in a park to save the latest victim, Melany Parker.

### Available Materials

1. Photo of park location  
2. Context about San Francisco area  
3. Information about Berkeley connection  
4. Format requirements for answer

### Solution Path

#### Location Research

1. Focus on Berkeley area parks  
2. Look for intersecting paths/trails  
3. Identify Ohlone Greenway  
4. Locate Cedar Rose Park  
5. Verify path intersection points

#### Answer Format

Must follow this format:

```

park-name-path-name
```

Correct answer:

```

cedar-rose-park-ohlone-greenway
```

### Format Requirements

1. All lowercase  
2. Hyphens between words  
3. No spaces  
4. Complete park name  
5. Complete path name  
6. Correct spelling

### Common Pitfalls to Avoid

1. Wrong case usage  
2. Missing hyphens  
3. Incorrect park name spelling  
4. Partial path names  
5. Extra spaces  
6. Wrong word order

### Research Tools

1. Google Maps  
2. Berkeley parks directory  
3. Trail maps  
4. Local area guides  
5. Street View verification

### Verification Steps

1. Confirm park name  
2. Verify path/greenway name  
3. Check formatting  
4. Validate hyphenation  
5. Confirm case sensitivity

Remember: Time is critical in this challenge, as it simulates a real rescue situation. Focus on Berkeley area parks and major trails/greenways first.

