## Copycat Killer

This contract involves analyzing the web browsing history, bookmarks, and cached data from the laptop of a “Copycat Killer” – a deranged individual who is recreating the crimes of a notorious serial killer named Maison. The FBI has secured the laptop and tasked the Tiberian Order with extracting key information to help track down the killer and prevent further atrocities.

## Challenge Objectives

* Examine the browser data files to uncover suspicious activities and hidden information  
* Piece together a timeline of events based on the available evidence  
* Assemble the final flag by combining the hidden clues

## Solution Steps

### Step 1: Initial Analysis

The player is provided with a ZIP file containing various browser data files, including:

* History  
* Bookmarks  
* cached\_image.png  
* Downloads  
* Web Data (including encrypted Login Data)  
* debug.log  
* Cookies  
* Extensions folder

The player should extract and begin analyzing these files.

### Step 2: Analyzing Browser History

Using a SQLite browser, the player can examine the History file and look for suspicious URLs. This includes:

* https://pastebin.com/copy (containing part of the flag: “copy”)  
* Other notable visits like competitor’s website, secure file transfer searches, and potential job searches

### Step 3: Examining Bookmarks

By opening the Bookmarks file, the player can find more suspicious entries, including:

* “Project Nexus” with a URL on the competitor’s domain (containing part of the flag: “cat”)  
* Other bookmarks like “SecureTransfer Pro” and “QuantumCoin Exchange”

### Step 4: Investigating Cached Images

The player should open the cached\_image.png file and adjust the brightness/contrast to reveal hidden text in the bottom right corner: “kitty” (the final part of the flag).

### Step 5: Decrypting Login Data

The player can find the encryption key in the debug.log file and use it to decrypt the Login Data file, which reveals suspicious login credentials.

### Step 6: Analyzing Downloads

Examining the Downloads database, the player can find suspicious files like quarterly reports, research results, and project schematics.

### Step 7: Checking Web Data

The Web Data file contains autofill data, including the name, email, company, and credit card information of the suspect.

### Step 8: Investigating Browser Extensions

The player can find a comment in the background.js file of the “quantumleap\_productivity\_suite” extension, hinting at a “copycat” module.

### Step 9: Timeline Analysis

By combining the timestamps from the History and Downloads databases, the player can create a timeline of events, noting suspicious activities like visits to the competitor’s website, searches for secure file transfer methods, and downloads of sensitive documents.

### Step 10: Assembling the Flag

The player can now combine the hidden clues found throughout the analysis:

* “copy” from the browser history  
* “cat” from the bookmarks  
* “kitty” from the cached image

The full flag is: `FLAG{copycatkitty}`

## Tips for Players

* Thoroughly examine each data file for suspicious activities and hidden information  
* Use a variety of tools, such as SQLite browsers and image editors, to extract and analyze the data  
* Pay close attention to anomalies and potential red herrings to piece together the full story  
* Organize the findings into a timeline to better understand the suspect’s activities  
* Be meticulous in assembling the final flag from the various clues

