## The Butcher

This Hacktoria Contract revolves around a serial killer investigation in Berlin. The challenge involves decrypting a hex-encoded file to reveal a password for an encrypted archive.

## Challenge Objectives

* Decode a hex-encoded file  
* Retrieve the password for an encrypted archive

## Step-by-Step Solution

### Step 1: Hex Decoding

1. Take the hex text from the “password” file  
2. Use CyberChef to decode the hex values  
3. Set the output to be saved as an MP3 file

### Step 2: Audio Decoding

1. Play the decoded MP3 file  
2. Listen for the spoken password

### The Actual Solution

When you decode the hex text in CyberChef, it will generate an MP3 file.  
Upon playing the MP3, you’ll hear the password spoken:

**Password: `fgjkaergnadrmgkhngadrgle`**

## Solving the Challenge

* Open CyberChef  
* Paste the hex text  
* Use the “From Hex” operation  
* Save the output as an MP3  
* Play the MP3 to hear the password  
* Use the password `fgjkaergnadrmgkhngadrgle` to decrypt the archive

## Additional Context

The contract is themed around a fictional serial killer case in Berlin, with 18 victims. The CTF simulates a cyber investigation to decode a critical piece of evidence.

## Tips

* Ensure you’re using a tool like CyberChef that can handle hex decoding  
* Listen carefully to the audio to capture the exact password  
* Be precise when entering the password for decryption

