## Prisoner of War

A French soldier has been captured in Mali, and a photograph from an escaped child suggests he’s being held at a children’s facility. We need to identify the exact location using provided geographic context near Kayes.

### Available Materials

1. Photograph of the facility  
2. Area of Operation information  
3. Reference point: RN1 near “Posté de contrôle KAYES”  
4. Ambush coordinates: 14.495703,-11.156166

### Solution Path

#### Geographic Context

1. Focus on Kayes region of Mali  
2. Use RN1 road as primary reference  
3. Search for children’s facilities/homes  
4. Consider proximity to ambush location  
5. Look for matching architectural features

#### Location Parameters

* Region: Kayes, Mali  
* Near RN1 highway  
* Within operational range of French forces  
* Children’s facility/orphanage type building  
* Coordinates area: 14.453602,-11.399466

### Answer Format

Must follow this format:

```

village-d-enfants-sos-khouloum-kayes
```

Key formatting rules:

1. All lowercase  
2. Hyphens between all words  
3. French facility name  
4. Include full location name  
5. No spaces or special characters

### Research Tools

1. Satellite imagery  
2. NGO facility databases  
3. Local area maps  
4. Children’s home registries  
5. French military AOR maps

### Verification Steps

1. Match facility appearance  
2. Confirm location name  
3. Verify proximity to RN1  
4. Check distance from ambush site  
5. Validate exact spelling and format

Remember: Pay special attention to the French facility naming conventions and ensure all words are properly hyphenated in the answer.

