## Friendly Fire

The challenge involves identifying a tank that attacked South African forces near their border. A drone captured an image of the vehicle before forces had to retreat, and the task is to identify the specific model of the tank.

## Available Materials

1. Drone photograph of the unidentified tank  
2. Context of the incident location (northern South Africa)  
3. Information about the tank’s aggressive behavior  
4. Context that the tank was potentially disguised as a South African vehicle

## Solution Path

### Step 1: Visual Analysis

When analyzing the tank photo, focus on:

1. Hull design and shape  
2. Turret configuration  
3. Gun barrel characteristics  
4. Armor layout and design  
5. Distinctive features unique to specific manufacturers

### Step 2: Identifying the Tank

Key characteristics point to the Merkava Mk 4M:

* Distinctive sloped turret design  
* Unique front hull configuration  
* Characteristic Israeli armor layout  
* Specific engine compartment placement  
* Modern combat tank features

### Step 3: Answer Format

The answer must be submitted in this format:

```

israel-merkava-mk-4m
```

Key formatting rules:

1. All lowercase  
2. Hyphens between words  
3. No spaces  
4. Include manufacturer country  
5. Exact model designation

## Tips for Solvers

1. Study distinctive Merkava design features  
2. Compare with other modern main battle tanks  
3. Pay attention to specific Mk 4M variant features  
4. Look for Israeli tank design characteristics  
5. Verify exact model designation spelling

## Common Pitfalls to Avoid

1. Confusing with earlier Merkava variants  
2. Incorrect spelling of “merkava”  
3. Wrong case (must be all lowercase)  
4. Missing or extra hyphens  
5. Incorrect model number format  
6. Forgetting to include country name

## Research Resources

1. Modern military vehicle databases  
2. Tank recognition guides  
3. Israeli Defense Force equipment catalogs  
4. Military technology websites  
5. Tank comparison resources

## Verification Steps

To confirm you have the correct tank, verify:

1. Matches modern Merkava design  
2. Features specific to Mk 4M variant  
3. Fits timeline of deployment  
4. Size and capabilities match reported encounter  
5. All components of answer format are correct

## Key Identification Features

1. Front-engine design  
2. Sloped turret armor  
3. Distinctive commander’s cupola  
4. Unique hull shape  
5. Specific armor panel layout

Remember: The Merkava Mk 4M is Israel’s most advanced main battle tank, and its unique design features make it distinctly identifiable once you know what to look for.

