## Far Away Outpost

This contract involves tracking down a remote military outpost that is being used as a front for an animal poaching and smuggling operation in Kenya. The player must use the provided information and map to geolocate the outpost location.

## Challenge Objectives

* Identify the location of the remote outpost on the provided map  
* Generate the password in the correct format using the location details

## Solution Steps

### Step 1: Locate the Outpost

The briefing provides some context about a poaching operation that is using remote outposts in Kenya as a cover for their illicit activities. It also mentions that the Kenyan authorities have provided a map link:

[https://satellites.pro/Kenya\_map\#3.196123,39.445891,19](https://satellites.pro/Kenya_map#3.196123,39.445891,19)

By examining this map, the player should be able to identify the location of the remote outpost.

### Step 2: Generate the Password

The password format for this contract is:

```

country-county-road-nearest-t-split-road
```

Using the location details gathered from the map, the complete password would be:

```

kenya-wajir-ogorji-adadijole-ogorji-gurar
```

This includes the country, county, road name, nearest T-split road, and the final road name.

## Additional Context

The prologue provides a fictional scenario of Kenyan forest rangers apprehending a suspected poacher, which sets the stage for the overall poaching and smuggling operation that the player is tasked with investigating.

The briefing further explains the modus operandi of the poaching group, using humanitarian aid as a cover for their illicit activities in remote areas.

## Tips for Players

* Carefully examine the provided map link to identify the exact location of the outpost  
* Pay close attention to road names, intersections, and other geographic details  
* Ensure the password is formatted exactly as specified in the instructions  
* Be prepared for potential additional challenges or layers within the full contract

