## A Strange File

This contract involves investigating a strange file that was discovered during a police raid in Muscat, Oman. The file was found in a folder labeled “meeting location” and contains encoded information that the Oman authorities were unable to decipher.

## Challenge Objectives

* Decode the encoded text in the strange file  
* Geolocate the locations referenced in the decoded information  
* Generate the password using the specific location details

## Solution Steps

### Step 1: Decode the Strange File

The briefing states that the strange file could not be converted to readable text by the Oman authorities. To unravel the encoded information, the player can use online tools like “File to Hex” and “Hex to Text” converters.

After decoding the hex-encoded text, the player should find that it contains two images.

### Step 2: Geolocate the Images

The decoded images contain location-specific details that the player must use to identify the precise meeting spot.

### Step 3: Determine the What3Words Location

Using the location coordinates or other clues from the images, the player should be able to determine the What3Words location for the meeting spot, which is “definitive.doorpost.thickness”.

### Step 4: Generate the Password

The final password format is:

```

libya-nalut-dirj-47-definitive-doorpost-thickness-car-wash
```

This includes the country, district, city, area code, What3Words location, and the type of business (car wash) at the meeting spot.

## Additional Context

The prologue sets the stage by describing a police raid on a group of hackers operating out of an apartment in Muscat, Oman. This leads to the discovery of the strange file that the player must investigate.

The briefing provides additional details about the file and the Tiberian Order’s involvement in deciphering its contents to assist the Oman authorities.

## Tips for Players

* Utilize online tools and resources to effectively decode the hex-encoded text  
* Carefully analyze the decoded images to extract location-specific details  
* Use the What3Words service to determine the precise meeting spot  
* Ensure the final password is formatted correctly according to the instructions

